/*
 * Decompiled with CFR 0.152.
 */
package org.icatproject.icat.client;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParsingException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.icatproject.icat.client.HttpInputStream;
import org.icatproject.icat.client.IcatException;
import org.icatproject.icat.client.ParameterForLucene;
import org.icatproject.icat.client.Session;

public class ICAT {
    private static final String basePath = "/icat";
    private URI uri;

    public ICAT(String urlString) throws URISyntaxException {
        this.uri = new URI(urlString);
    }

    private void checkStatus(HttpResponse response) throws IcatException, IOException {
        StatusLine status = response.getStatusLine();
        if (status == null) {
            throw new IcatException(IcatException.IcatExceptionType.INTERNAL, "Status line returned is empty");
        }
        int rc = status.getStatusCode();
        if (rc / 100 != 2) {
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                throw new IcatException(IcatException.IcatExceptionType.INTERNAL, "No explanation provided");
            }
            String error = EntityUtils.toString((HttpEntity)entity, (Charset)Charset.defaultCharset());
            try {
                JsonParser parser = Json.createParser((InputStream)new ByteArrayInputStream(error.getBytes()));
                try {
                    String code = null;
                    String message = null;
                    String key = "";
                    int offset = -1;
                    while (parser.hasNext()) {
                        JsonParser.Event event = parser.next();
                        if (event == JsonParser.Event.KEY_NAME) {
                            key = parser.getString();
                            continue;
                        }
                        if (event == JsonParser.Event.VALUE_STRING) {
                            if (key.equals("code")) {
                                code = parser.getString();
                                continue;
                            }
                            if (!key.equals("message")) continue;
                            message = parser.getString();
                            continue;
                        }
                        if (event != JsonParser.Event.VALUE_NUMBER || !key.equals("offset")) continue;
                        offset = parser.getInt();
                    }
                    if (code == null || message == null) {
                        throw new IcatException(IcatException.IcatExceptionType.INTERNAL, error);
                    }
                    throw new IcatException(IcatException.IcatExceptionType.valueOf(code), message, offset);
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            catch (JsonParsingException e) {
                throw new IcatException(IcatException.IcatExceptionType.INTERNAL, error);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<Long> write(String sessionId, String entities) throws IcatException {
        URI uri = this.getUri(this.getUriBuilder("entityManager"));
        ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
        formparams.add(new BasicNameValuePair("sessionId", sessionId));
        formparams.add(new BasicNameValuePair("entities", entities));
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(uri);
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(formparams));
            ArrayList<Long> result = new ArrayList<Long>();
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);){
                this.checkStatus((HttpResponse)response);
                try (JsonParser parser = Json.createParser((InputStream)new ByteArrayInputStream(this.getString(response).getBytes()));){
                    block27: {
                        JsonParser.Event event = parser.next();
                        if (event != JsonParser.Event.START_ARRAY) {
                            throw new IcatException(IcatException.IcatExceptionType.INTERNAL, "Not a valid JSON array of longs");
                        }
                        while (parser.hasNext()) {
                            event = parser.next();
                            if (event == JsonParser.Event.VALUE_NUMBER) {
                                result.add(parser.getLong());
                                continue;
                            }
                            if (event != JsonParser.Event.END_ARRAY) {
                                continue;
                            }
                            break block27;
                        }
                        throw new IcatException(IcatException.IcatExceptionType.INTERNAL, "Not a valid JSON array of longs");
                    }
                    ArrayList<Long> arrayList = result;
                    return arrayList;
                }
            }
        }
        catch (IOException e) {
            throw new IcatException(IcatException.IcatExceptionType.INTERNAL, e.getClass() + " " + e.getMessage());
        }
    }

    void delete(String sessionId, String entities) throws IcatException {
        URIBuilder uriBuilder = this.getUriBuilder("entityManager");
        uriBuilder.setParameter("sessionId", sessionId);
        uriBuilder.setParameter("entities", entities);
        URI uri = this.getUri(uriBuilder);
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpDelete httpDelete = new HttpDelete(uri);
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpDelete);){
                this.expectNothing(response);
            }
        }
        catch (IOException e) {
            throw new IcatException(IcatException.IcatExceptionType.INTERNAL, e.getClass() + " " + e.getMessage());
        }
    }

    private void expectNothing(CloseableHttpResponse response) throws IcatException, IOException {
        String error;
        this.checkStatus((HttpResponse)response);
        HttpEntity entity = response.getEntity();
        if (entity != null && !(error = EntityUtils.toString((HttpEntity)entity, (Charset)Charset.defaultCharset())).isEmpty()) {
            JsonParser parser = Json.createParser((InputStream)new ByteArrayInputStream(error.getBytes()));
            try {
                throw new IcatException(IcatException.IcatExceptionType.INTERNAL, "No http entity expected in response " + error);
            }
            catch (Throwable throwable) {
                if (parser != null) {
                    try {
                        parser.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    InputStream exportMetaData(String sessionId, String query, Session.Attributes attributes) throws IcatException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JsonGenerator gen = Json.createGenerator((OutputStream)baos);
        gen.writeStartObject().write("sessionId", sessionId);
        if (query != null) {
            gen.write("query", query);
        }
        gen.write("attributes", attributes.name().toLowerCase()).writeEnd().close();
        URIBuilder uriBuilder = this.getUriBuilder("port");
        uriBuilder.setParameter("json", baos.toString());
        URI uri = this.getUri(uriBuilder);
        CloseableHttpResponse response = null;
        CloseableHttpClient httpclient = null;
        HttpGet httpGet = new HttpGet(uri);
        boolean closeNeeded = true;
        try {
            httpclient = HttpClients.createDefault();
            response = httpclient.execute((HttpUriRequest)httpGet);
            this.checkStatus((HttpResponse)response);
            closeNeeded = false;
            HttpInputStream httpInputStream = new HttpInputStream(httpclient, response);
            return httpInputStream;
        }
        catch (IOException e) {
            throw new IcatException(IcatException.IcatExceptionType.INTERNAL, e.getClass() + " " + e.getMessage());
        }
        finally {
            if (closeNeeded && httpclient != null) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Exception exception) {}
                    }
                    httpclient.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    String get(String sessionId, String query, long id) throws IcatException {
        URIBuilder uriBuilder = this.getUriBuilder("entityManager");
        uriBuilder.setParameter("sessionId", sessionId);
        uriBuilder.setParameter("query", query);
        uriBuilder.setParameter("id", Long.toString(id));
        URI uri = this.getUri(uriBuilder);
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            String string;
            block14: {
                HttpGet httpGet = new HttpGet(uri);
                CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
                try {
                    string = this.getString(response);
                    if (response == null) break block14;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return string;
        }
        catch (IOException e) {
            throw new IcatException(IcatException.IcatExceptionType.INTERNAL, e.getClass() + " " + e.getMessage());
        }
    }

    private String getStringFromJson(String input, String sought) throws IcatException {
        try (JsonParser parser = Json.createParser((InputStream)new ByteArrayInputStream(input.getBytes()));){
            String key = "";
            while (parser.hasNext()) {
                JsonParser.Event event = parser.next();
                if (event == JsonParser.Event.KEY_NAME) {
                    key = parser.getString();
                    continue;
                }
                if (event != JsonParser.Event.VALUE_STRING && event != JsonParser.Event.VALUE_NUMBER || !key.equals(sought)) continue;
                String string = parser.getString();
                return string;
            }
            throw new IcatException(IcatException.IcatExceptionType.INTERNAL, "No " + sought + " in " + input);
        }
    }

    private long getLongFromJson(String input, String sought) throws IcatException {
        try (JsonParser parser = Json.createParser((InputStream)new ByteArrayInputStream(input.getBytes()));){
            String key = "";
            while (parser.hasNext()) {
                JsonParser.Event event = parser.next();
                if (event == JsonParser.Event.KEY_NAME) {
                    key = parser.getString();
                    continue;
                }
                if (event != JsonParser.Event.VALUE_NUMBER || !key.equals(sought)) continue;
                long l = parser.getLong();
                return l;
            }
            throw new IcatException(IcatException.IcatExceptionType.INTERNAL, "No " + sought + " in " + input);
        }
    }

    private boolean getBooleanFromJson(String input, String sought) throws IcatException {
        try (JsonParser parser = Json.createParser((InputStream)new ByteArrayInputStream(input.getBytes()));){
            String key = "";
            while (parser.hasNext()) {
                JsonParser.Event event = parser.next();
                if (event == JsonParser.Event.KEY_NAME) {
                    key = parser.getString();
                    continue;
                }
                if (event == JsonParser.Event.VALUE_TRUE) {
                    if (!key.equals(sought)) continue;
                    boolean bl = true;
                    return bl;
                }
                if (event != JsonParser.Event.VALUE_FALSE || !key.equals(sought)) continue;
                boolean bl = false;
                return bl;
            }
            throw new IcatException(IcatException.IcatExceptionType.INTERNAL, "No " + sought + " in " + input);
        }
    }

    /*
     * Exception decompiling
     */
    double getRemainingMinutes(String sessionId) throws IcatException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getString(CloseableHttpResponse response) throws IcatException, IOException {
        this.checkStatus((HttpResponse)response);
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            throw new IcatException(IcatException.IcatExceptionType.INTERNAL, "No http entity returned in response");
        }
        return EntityUtils.toString((HttpEntity)entity, (Charset)Charset.defaultCharset());
    }

    private URI getUri(URIBuilder uriBuilder) throws IcatException {
        try {
            URI uri = uriBuilder.build();
            if (uri.toString().length() > 2048) {
                throw new IcatException(IcatException.IcatExceptionType.BAD_PARAMETER, "Generated URI is of length " + uri.toString().length() + " which exceeds 2048");
            }
            return uri;
        }
        catch (URISyntaxException e) {
            throw new IcatException(IcatException.IcatExceptionType.INTERNAL, e.getClass() + " " + e.getMessage());
        }
    }

    private URIBuilder getUriBuilder(String path) {
        return new URIBuilder(this.uri).setPath("/icat/" + path);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    String getUserName(String sessionId) throws IcatException {
        URI uri = this.getUri(this.getUriBuilder("session/" + sessionId));
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            String string;
            block14: {
                HttpGet httpGet = new HttpGet(uri);
                CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
                try {
                    String responseString = this.getString(response);
                    string = this.getStringFromJson(responseString, "userName");
                    if (response == null) break block14;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return string;
        }
        catch (IOException e) {
            throw new IcatException(IcatException.IcatExceptionType.INTERNAL, e.getClass() + " " + e.getMessage());
        }
    }

    void importMetaData(String sessionId, Path path, Session.DuplicateAction duplicate, Session.Attributes attributes) throws IcatException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JsonGenerator gen = Json.createGenerator((OutputStream)baos);
        gen.writeStartObject().write("sessionId", sessionId).write("duplicate", duplicate.name().toLowerCase()).write("attributes", attributes.name().toLowerCase()).writeEnd().close();
        URI uri = this.getUri(this.getUriBuilder("port"));
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            BufferedInputStream stream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
            HttpEntity httpEntity = MultipartEntityBuilder.create().addPart("json", (ContentBody)new StringBody(baos.toString(), ContentType.TEXT_PLAIN)).addPart("file", (ContentBody)new InputStreamBody((InputStream)stream, ContentType.APPLICATION_OCTET_STREAM, "")).build();
            HttpPost httpPost = new HttpPost(uri);
            httpPost.setEntity(httpEntity);
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);){
                this.expectNothing(response);
            }
        }
        catch (IOException e) {
            throw new IcatException(IcatException.IcatExceptionType.INTERNAL, e.getClass() + " " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean isLoggedIn(String userName) throws IcatException {
        URI uri = this.getUri(this.getUriBuilder("user/" + userName));
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            boolean bl;
            block14: {
                HttpGet httpGet = new HttpGet(uri);
                CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
                try {
                    String responseString = this.getString(response);
                    bl = this.getBooleanFromJson(responseString, "loggedIn");
                    if (response == null) break block14;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return bl;
        }
        catch (IOException e) {
            throw new IcatException(IcatException.IcatExceptionType.INTERNAL, e.getClass() + " " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Session login(String plugin, Map<String, String> credentials) throws IcatException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JsonGenerator gen = Json.createGenerator((OutputStream)baos);
        gen.writeStartObject().write("plugin", plugin).writeStartArray("credentials");
        for (Map.Entry<String, String> entry : credentials.entrySet()) {
            gen.writeStartObject().write(entry.getKey(), entry.getValue()).writeEnd();
        }
        gen.writeEnd().writeEnd().close();
        URI uri = this.getUri(this.getUriBuilder("session"));
        ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
        formparams.add(new BasicNameValuePair("json", baos.toString()));
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            Session session;
            block15: {
                HttpPost httpPost = new HttpPost(uri);
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(formparams));
                CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
                try {
                    String responseString = this.getString(response);
                    String sessionId = this.getStringFromJson(responseString, "sessionId");
                    session = new Session(this, sessionId);
                    if (response == null) break block15;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return session;
        }
        catch (IOException e) {
            throw new IcatException(IcatException.IcatExceptionType.INTERNAL, e.getClass() + " " + e.getMessage());
        }
    }

    public Session getSession(String sessionId) {
        return new Session(this, sessionId);
    }

    void logout(String sessionId) throws IcatException {
        URI uri = this.getUri(this.getUriBuilder("session/" + sessionId));
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpDelete httpDelete = new HttpDelete(uri);
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpDelete);){
                this.expectNothing(response);
            }
        }
        catch (IOException e) {
            throw new IcatException(IcatException.IcatExceptionType.INTERNAL, e.getClass() + " " + e.getMessage());
        }
    }

    void refresh(String sessionId) throws IcatException {
        URI uri = this.getUri(this.getUriBuilder("session/" + sessionId));
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpPut httpPut = new HttpPut(uri);
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPut);){
                this.expectNothing(response);
            }
        }
        catch (IOException e) {
            throw new IcatException(IcatException.IcatExceptionType.INTERNAL, e.getClass() + " " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    String search(String sessionId, String query) throws IcatException {
        URIBuilder uriBuilder = this.getUriBuilder("entityManager");
        uriBuilder.setParameter("sessionId", sessionId);
        uriBuilder.setParameter("query", query);
        URI uri = this.getUri(uriBuilder);
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            String string;
            block14: {
                HttpGet httpGet = new HttpGet(uri);
                CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
                try {
                    string = this.getString(response);
                    if (response == null) break block14;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return string;
        }
        catch (IOException e) {
            throw new IcatException(IcatException.IcatExceptionType.INTERNAL, e.getClass() + " " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public String getApiVersion() throws IcatException {
        URI uri = this.getUri(this.getUriBuilder("version"));
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            String string;
            block14: {
                HttpGet httpGet = new HttpGet(uri);
                CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
                try {
                    String responseString = this.getString(response);
                    string = this.getStringFromJson(responseString, "version");
                    if (response == null) break block14;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return string;
        }
        catch (IOException e) {
            throw new IcatException(IcatException.IcatExceptionType.INTERNAL, e.getClass() + " " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String getVersion() throws IcatException {
        URI uri = this.getUri(this.getUriBuilder("version"));
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            String string;
            block14: {
                HttpGet httpGet = new HttpGet(uri);
                CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
                try {
                    String responseString = this.getString(response);
                    string = this.getStringFromJson(responseString, "version");
                    if (response == null) break block14;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return string;
        }
        catch (IOException e) {
            throw new IcatException(IcatException.IcatExceptionType.INTERNAL, e.getClass() + " " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    String searchInvestigations(String sessionId, String user, String text, Date lower, Date upper, List<ParameterForLucene> parameters, List<String> samples, String userFullName, int maxResults) throws IcatException {
        URIBuilder uriBuilder = this.getUriBuilder("lucene/data");
        uriBuilder.setParameter("sessionId", sessionId);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (JsonGenerator gen = Json.createGenerator((OutputStream)baos);){
            gen.writeStartObject();
            gen.write("target", "Investigation");
            if (user != null) {
                gen.write("user", user);
            }
            if (text != null) {
                gen.write("text", text);
            }
            if (lower != null) {
                gen.write("lower", this.roundMinute(lower, 0L));
            }
            if (upper != null) {
                gen.write("upper", this.roundMinute(upper, 59999L));
            }
            if (parameters != null && !parameters.isEmpty()) {
                this.writeParameters(gen, parameters);
            }
            if (samples != null && !samples.isEmpty()) {
                gen.writeStartArray("samples");
                for (String sample : samples) {
                    gen.write(sample);
                }
                gen.writeEnd();
            }
            if (userFullName != null) {
                gen.write("userFullName", userFullName);
            }
            gen.writeEnd();
        }
        uriBuilder.setParameter("query", baos.toString());
        uriBuilder.setParameter("maxCount", Integer.toString(maxResults));
        URI uri = this.getUri(uriBuilder);
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            String string;
            block29: {
                HttpGet httpGet = new HttpGet(uri);
                CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
                try {
                    string = this.getString(response);
                    if (response == null) break block29;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return string;
        }
        catch (IOException e) {
            throw new IcatException(IcatException.IcatExceptionType.INTERNAL, e.getClass() + " " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String searchDocuments(String target, String sessionId, String user, String text, Date lower, Date upper, List<ParameterForLucene> parameters, String userFullName, String searchAfter, int maxCount, String sort, JsonArray facets) throws IcatException {
        URIBuilder uriBuilder = this.getUriBuilder("search/documents");
        uriBuilder.setParameter("sessionId", sessionId);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (JsonGenerator gen = Json.createGenerator((OutputStream)baos);){
            gen.writeStartObject();
            gen.write("target", target);
            if (user != null) {
                gen.write("user", user);
            }
            if (text != null) {
                gen.write("text", text);
            }
            if (lower != null) {
                gen.write("lower", this.roundMinute(lower, 0L));
            }
            if (upper != null) {
                gen.write("upper", this.roundMinute(upper, 59999L));
            }
            if (parameters != null && !parameters.isEmpty()) {
                this.writeParameters(gen, parameters);
            }
            if (userFullName != null) {
                gen.write("userFullName", userFullName);
            }
            if (facets != null) {
                gen.write("facets", (JsonValue)facets);
            }
            gen.writeEnd();
        }
        uriBuilder.setParameter("query", baos.toString());
        uriBuilder.setParameter("search_after", searchAfter);
        uriBuilder.setParameter("maxCount", Integer.toString(maxCount));
        uriBuilder.setParameter("sort", sort);
        URI uri = this.getUri(uriBuilder);
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            String string;
            block28: {
                HttpGet httpGet = new HttpGet(uri);
                CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
                try {
                    string = this.getString(response);
                    if (response == null) break block28;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return string;
        }
        catch (IOException e) {
            throw new IcatException(IcatException.IcatExceptionType.INTERNAL, e.getClass() + " " + e.getMessage());
        }
    }

    String searchInvestigations(String sessionId, String user, String text, Date lower, Date upper, List<ParameterForLucene> parameters, String userFullName, String searchAfter, int maxCount, String sort, JsonArray facets) throws IcatException {
        return this.searchDocuments("Investigation", sessionId, user, text, lower, upper, parameters, userFullName, searchAfter, maxCount, sort, facets);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    String searchDatasets(String sessionId, String user, String text, Date lower, Date upper, List<ParameterForLucene> parameters, int maxResults) throws IcatException {
        URIBuilder uriBuilder = this.getUriBuilder("lucene/data");
        uriBuilder.setParameter("sessionId", sessionId);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (JsonGenerator gen = Json.createGenerator((OutputStream)baos);){
            gen.writeStartObject();
            gen.write("target", "Dataset");
            if (user != null) {
                gen.write("user", user);
            }
            if (text != null) {
                gen.write("text", text);
            }
            if (lower != null) {
                gen.write("lower", this.roundMinute(lower, 0L));
            }
            if (upper != null) {
                gen.write("upper", this.roundMinute(upper, 59999L));
            }
            if (parameters != null && !parameters.isEmpty()) {
                this.writeParameters(gen, parameters);
            }
            gen.writeEnd();
        }
        uriBuilder.setParameter("query", baos.toString());
        uriBuilder.setParameter("maxCount", Integer.toString(maxResults));
        URI uri = this.getUri(uriBuilder);
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            String string;
            block26: {
                HttpGet httpGet = new HttpGet(uri);
                CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
                try {
                    string = this.getString(response);
                    if (response == null) break block26;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return string;
        }
        catch (IOException e) {
            throw new IcatException(IcatException.IcatExceptionType.INTERNAL, e.getClass() + " " + e.getMessage());
        }
    }

    String searchDatasets(String sessionId, String user, String text, Date lower, Date upper, List<ParameterForLucene> parameters, String searchAfter, int maxCount, String sort, JsonArray facets) throws IcatException {
        return this.searchDocuments("Dataset", sessionId, user, text, lower, upper, parameters, null, searchAfter, maxCount, sort, facets);
    }

    private void writeParameters(JsonGenerator gen, List<ParameterForLucene> parameters) {
        gen.writeStartArray("parameters");
        for (ParameterForLucene parameter : parameters) {
            gen.writeStartObject();
            if (parameter.getName() != null) {
                gen.write("name", parameter.getName());
            }
            if (parameter.getUnits() != null) {
                gen.write("units", parameter.getUnits());
            }
            if (parameter.getStringValue() != null) {
                gen.write("stringValue", parameter.getStringValue());
            } else if (parameter.getLowerDateValue() != null && parameter.getUpperDateValue() != null) {
                gen.write("lowerDateValue", this.roundMinute(parameter.getLowerDateValue(), 0L));
                gen.write("upperDateValue", this.roundMinute(parameter.getUpperDateValue(), 59999L));
            } else if (parameter.getLowerNumericValue() != null && parameter.getUpperNumericValue() != null) {
                gen.write("lowerNumericValue", parameter.getLowerNumericValue().doubleValue());
                gen.write("upperNumericValue", parameter.getUpperNumericValue().doubleValue());
            }
            gen.writeEnd();
        }
        gen.writeEnd();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String getProperties() throws IcatException {
        URI uri = this.getUri(this.getUriBuilder("properties"));
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            String string;
            block14: {
                HttpGet httpGet = new HttpGet(uri);
                CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
                try {
                    string = this.getString(response);
                    if (response == null) break block14;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return string;
        }
        catch (IOException e) {
            throw new IcatException(IcatException.IcatExceptionType.INTERNAL, e.getClass() + " " + e.getMessage());
        }
    }

    void luceneClear(String sessionId) throws IcatException {
        URIBuilder uriBuilder = this.getUriBuilder("lucene/db");
        uriBuilder.setParameter("sessionId", sessionId);
        URI uri = this.getUri(uriBuilder);
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpDelete httpDelete = new HttpDelete(uri);
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpDelete);){
                this.expectNothing(response);
            }
        }
        catch (IOException e) {
            throw new IcatException(IcatException.IcatExceptionType.INTERNAL, e.getClass() + " " + e.getMessage());
        }
    }

    void luceneCommit(String sessionId) throws IcatException {
        URI uri = this.getUri(this.getUriBuilder("lucene/db"));
        ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
        formparams.add(new BasicNameValuePair("sessionId", sessionId));
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(uri);
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(formparams));
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);){
                this.expectNothing(response);
            }
        }
        catch (IOException e) {
            throw new IcatException(IcatException.IcatExceptionType.INTERNAL, e.getClass() + " " + e.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    List<String> luceneGetPopulating(String sessionId) throws IcatException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void lucenePopulate(String sessionId, String entityName, Long minId, Long maxId, Boolean delete) throws IcatException {
        URI uri = this.getUri(this.getUriBuilder("lucene/db/" + entityName));
        ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
        formparams.add(new BasicNameValuePair("sessionId", sessionId));
        formparams.add(new BasicNameValuePair("minId", minId.toString()));
        if (maxId != null) {
            formparams.add(new BasicNameValuePair("maxId", maxId.toString()));
        }
        formparams.add(new BasicNameValuePair("delete", delete.toString()));
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(uri);
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(formparams));
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);){
                this.expectNothing(response);
            }
        }
        catch (IOException e) {
            throw new IcatException(IcatException.IcatExceptionType.INTERNAL, e.getClass() + " " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    String searchDatafiles(String sessionId, String user, String text, Date lower, Date upper, List<ParameterForLucene> parameters, int maxResults) throws IcatException {
        URIBuilder uriBuilder = this.getUriBuilder("lucene/data");
        uriBuilder.setParameter("sessionId", sessionId);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (JsonGenerator gen = Json.createGenerator((OutputStream)baos);){
            gen.writeStartObject();
            gen.write("target", "Datafile");
            if (user != null) {
                gen.write("user", user);
            }
            if (text != null) {
                gen.write("text", text);
            }
            if (lower != null) {
                gen.write("lower", this.roundMinute(lower, 0L));
            }
            if (upper != null) {
                gen.write("upper", this.roundMinute(upper, 59999L));
            }
            if (parameters != null && !parameters.isEmpty()) {
                this.writeParameters(gen, parameters);
            }
            gen.writeEnd();
        }
        uriBuilder.setParameter("query", baos.toString());
        uriBuilder.setParameter("maxCount", Integer.toString(maxResults));
        URI uri = this.getUri(uriBuilder);
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            String string;
            block26: {
                HttpGet httpGet = new HttpGet(uri);
                CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
                try {
                    string = this.getString(response);
                    if (response == null) break block26;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return string;
        }
        catch (IOException e) {
            throw new IcatException(IcatException.IcatExceptionType.INTERNAL, e.getClass() + " " + e.getMessage());
        }
    }

    String searchDatafiles(String sessionId, String user, String text, Date lower, Date upper, List<ParameterForLucene> parameters, String searchAfter, int maxCount, String sort, JsonArray facets) throws IcatException {
        return this.searchDocuments("Datafile", sessionId, user, text, lower, upper, parameters, null, searchAfter, maxCount, sort, facets);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    long cloneEntity(String sessionId, String name, long id, Map<String, String> keys) throws IcatException {
        URI uri = this.getUri(this.getUriBuilder("cloner"));
        ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
        formparams.add(new BasicNameValuePair("sessionId", sessionId));
        formparams.add(new BasicNameValuePair("name", name));
        formparams.add(new BasicNameValuePair("id", Long.toString(id)));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (JsonGenerator gen = Json.createGenerator((OutputStream)baos);){
            gen.writeStartObject();
            for (Map.Entry<String, String> entry : keys.entrySet()) {
                gen.write(entry.getKey(), entry.getValue());
            }
            gen.writeEnd();
        }
        formparams.add(new BasicNameValuePair("keys", baos.toString()));
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            long l;
            block22: {
                HttpPost httpPost = new HttpPost(uri);
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(formparams));
                CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
                try {
                    String responseString = this.getString(response);
                    l = this.getLongFromJson(responseString, "id");
                    if (response == null) break block22;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return l;
        }
        catch (IOException e) {
            throw new IcatException(IcatException.IcatExceptionType.INTERNAL, e.getClass() + " " + e.getMessage());
        }
    }

    public void waitMillis(String sessionId, long ms) throws IcatException {
        URI uri = this.getUri(this.getUriBuilder("waitMillis"));
        ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
        formparams.add(new BasicNameValuePair("sessionId", sessionId));
        formparams.add(new BasicNameValuePair("ms", Long.toString(ms)));
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(uri);
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(formparams));
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);){
                this.expectNothing(response);
            }
        }
        catch (IOException e) {
            throw new IcatException(IcatException.IcatExceptionType.INTERNAL, e.getClass() + " " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String list(String sessionId, String path) throws IcatException {
        URIBuilder uriBuilder = this.getUriBuilder("list");
        uriBuilder.setParameter("sessionId", sessionId);
        uriBuilder.setParameter("path", path);
        URI uri = this.getUri(uriBuilder);
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            String string;
            block14: {
                HttpGet httpGet = new HttpGet(uri);
                CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
                try {
                    string = this.getString(response);
                    if (response == null) break block14;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return string;
        }
        catch (IOException e) {
            throw new IcatException(IcatException.IcatExceptionType.INTERNAL, e.getClass() + " " + e.getMessage());
        }
    }

    private long roundMinute(Date date, long offset) {
        return date.getTime() / 60000L * 60000L + offset;
    }
}

