/*
 * Decompiled with CFR 0.152.
 */
package org.icatproject.icat.client;

import jakarta.json.JsonArray;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.icatproject.icat.client.ICAT;
import org.icatproject.icat.client.IcatException;
import org.icatproject.icat.client.ParameterForLucene;

public class Session {
    private ICAT icat;
    private String sessionId;

    Session(ICAT icat, String sessionId) {
        this.icat = icat;
        this.sessionId = sessionId;
    }

    public List<Long> write(String entities) throws IcatException {
        return this.icat.write(this.sessionId, entities);
    }

    @Deprecated
    public List<Long> create(String entities) throws IcatException {
        return this.icat.write(this.sessionId, entities);
    }

    public void delete(String entities) throws IcatException {
        this.icat.delete(this.sessionId, entities);
    }

    public InputStream exportMetaData(Attributes attributes) throws IcatException {
        return this.icat.exportMetaData(this.sessionId, null, attributes);
    }

    public InputStream exportMetaData(String query, Attributes attributes) throws IcatException {
        return this.icat.exportMetaData(this.sessionId, query, attributes);
    }

    public double getRemainingMinutes() throws IcatException {
        return this.icat.getRemainingMinutes(this.sessionId);
    }

    public String getId() {
        return this.sessionId;
    }

    public String getUserName() throws IcatException {
        return this.icat.getUserName(this.sessionId);
    }

    public void importMetaData(Path path, DuplicateAction duplicateAction, Attributes attributes) throws IcatException {
        this.icat.importMetaData(this.sessionId, path, duplicateAction, attributes);
    }

    public void logout() throws IcatException {
        this.icat.logout(this.sessionId);
    }

    public void refresh() throws IcatException {
        this.icat.refresh(this.sessionId);
    }

    public String search(String query) throws IcatException {
        return this.icat.search(this.sessionId, query);
    }

    public String get(String query, long id) throws IcatException {
        return this.icat.get(this.sessionId, query, id);
    }

    @Deprecated
    public String searchInvestigations(String user, String text, Date lower, Date upper, List<ParameterForLucene> parameters, List<String> samples, String userFullName, int maxResults) throws IcatException {
        return this.icat.searchInvestigations(this.sessionId, user, text, lower, upper, parameters, samples, userFullName, maxResults);
    }

    public String searchInvestigations(String user, String text, Date lower, Date upper, List<ParameterForLucene> parameters, String userFullName, String searchAfter, int maxCount, String sort, JsonArray facets) throws IcatException {
        return this.icat.searchInvestigations(this.sessionId, user, text, lower, upper, parameters, userFullName, searchAfter, maxCount, sort, facets);
    }

    @Deprecated
    public String searchDatasets(String user, String text, Date lower, Date upper, List<ParameterForLucene> parameters, int maxResults) throws IcatException {
        return this.icat.searchDatasets(this.sessionId, user, text, lower, upper, parameters, maxResults);
    }

    public String searchDatasets(String user, String text, Date lower, Date upper, List<ParameterForLucene> parameters, String searchAfter, int maxCount, String sort, JsonArray facets) throws IcatException {
        return this.icat.searchDatasets(this.sessionId, user, text, lower, upper, parameters, searchAfter, maxCount, sort, facets);
    }

    public void luceneClear() throws IcatException {
        this.icat.luceneClear(this.sessionId);
    }

    public void luceneCommit() throws IcatException {
        this.icat.luceneCommit(this.sessionId);
    }

    @Deprecated
    public void lucenePopulate(String entityName, long minId) throws IcatException {
        this.icat.lucenePopulate(this.sessionId, entityName, minId, null, true);
    }

    public void searchPopulate(String entityName, long minId, long maxId, boolean delete) throws IcatException {
        this.icat.lucenePopulate(this.sessionId, entityName, minId, maxId, delete);
    }

    public List<String> luceneGetPopulating() throws IcatException {
        return this.icat.luceneGetPopulating(this.sessionId);
    }

    @Deprecated
    public String searchDatafiles(String user, String text, Date lower, Date upper, List<ParameterForLucene> parameters, int maxResults) throws IcatException {
        return this.icat.searchDatafiles(this.sessionId, user, text, lower, upper, parameters, maxResults);
    }

    public String searchDatafiles(String user, String text, Date lower, Date upper, List<ParameterForLucene> parameters, String searchAfter, int maxCount, String sort, JsonArray facets) throws IcatException {
        return this.icat.searchDatafiles(this.sessionId, user, text, lower, upper, parameters, searchAfter, maxCount, sort, facets);
    }

    public long cloneEntity(String name, long id, Map<String, String> keys) throws IcatException {
        return this.icat.cloneEntity(this.sessionId, name, id, keys);
    }

    public void waitMillis(long ms) throws IcatException {
        this.icat.waitMillis(this.sessionId, ms);
    }

    public String list(String path) throws IcatException {
        return this.icat.list(this.sessionId, path);
    }

    public static enum Attributes {
        ALL,
        USER;

    }

    public static enum DuplicateAction {
        CHECK,
        IGNORE,
        OVERWRITE,
        THROW;

    }
}

